/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.rsf;

import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;

public class RsfFru
implements PersistentData {
    private String location;
    private String partNumber;
    private String confidenceLevel;
    private final int version = 0;
    private static final long serialVersionUID = 1L;

    public RsfFru(String loc, String pn, String confidenceLevel) throws IllegalArgumentException {
        if (pn == null || confidenceLevel == null) {
            throw new IllegalArgumentException();
        }
        this.location = loc;
        this.partNumber = pn;
        this.confidenceLevel = confidenceLevel;
    }

    public RsfFru(CommonPaFru paFru) throws IllegalArgumentException {
        if (paFru == null) {
            throw new IllegalArgumentException("null CommonPaFru in RsfFru constructor");
        }
        this.location = paFru.getLocation();
        this.partNumber = paFru.getPartNumber();
        this.confidenceLevel = paFru.getPercent();
        if (this.location == null || this.partNumber == null || this.confidenceLevel == null) {
            throw new IllegalArgumentException("Required attribute of CommonPaFru is null in RsfFru constructor");
        }
    }

    public boolean equals(Object o) {
        return o != null && o instanceof RsfFru && (this.location != null && this.location.equals(((RsfFru)o).location) || this.location == ((RsfFru)o).location) && this.partNumber.equals(((RsfFru)o).partNumber) && this.confidenceLevel.equals(((RsfFru)o).confidenceLevel);
    }

    public int hashCode() {
        return (this.location + this.partNumber + this.confidenceLevel).hashCode();
    }

    public int getVersion() {
        return 0;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPartNumber() {
        return this.partNumber;
    }

    public String getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public String toXmlTransferFormat() {
        StringBuffer buffer = new StringBuffer("<FRU><LOC>");
        buffer.append(this.location);
        buffer.append("</LOC><PN>");
        buffer.append(this.partNumber);
        buffer.append("</PN><WT>");
        buffer.append(this.confidenceLevel);
        buffer.append("</WT></FRU>");
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(" <FRU><LOC>");
        buffer.append(this.location);
        buffer.append("</LOC><PN>");
        buffer.append(this.partNumber);
        buffer.append("</PN><WT>");
        buffer.append(this.confidenceLevel);
        buffer.append("</WT></FRU>\n");
        return buffer.toString();
    }
}

